/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.Devices;
import com.quantumdata.sct.dao.jaxb.Standard;
import com.quantumdata.sct.dao.jaxb.impl.DevicesTypeImpl;
import com.quantumdata.sct.dao.vo.DeviceTypeVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;

public class DeviceTypeDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            Devices devices = (Devices)this.daoObject;
            int n = devices.getDevices().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)((Devices)this.daoObject).getDevices().get(i);
                this.daoCollection.put(deviceImpl.getId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((DevicesTypeImpl)this.daoObject).getDevices().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)((Devices)this.daoObject).getDevices().get(i);
            iPersistableArray[i] = this.createPersistable(deviceImpl);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Standard) {
            Standard standard = (Standard)object;
            object2 = standard.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        DeviceTypeVO deviceTypeVO = new DeviceTypeVO();
        if (object instanceof DevicesTypeImpl.DeviceImpl) {
            this.copyFrom((DevicesTypeImpl.DeviceImpl)object, deviceTypeVO);
        }
        return deviceTypeVO;
    }

    protected void copyFrom(DevicesTypeImpl.DeviceImpl deviceImpl, DeviceTypeVO deviceTypeVO) {
        deviceTypeVO.setId(deviceImpl.getId());
        deviceTypeVO.setName(deviceImpl.getTitle());
        deviceTypeVO.setUutType(deviceImpl.getUutType());
    }

    protected void copyTo(DevicesTypeImpl.DeviceImpl deviceImpl, DeviceTypeVO deviceTypeVO) {
        deviceImpl.setId((String)deviceTypeVO.getId());
        deviceImpl.setTitle(deviceTypeVO.getName());
        deviceImpl.setUutType(deviceTypeVO.getUutType());
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        if (iPersistable instanceof DeviceTypeVO) {
            DeviceTypeVO deviceTypeVO = (DeviceTypeVO)iPersistable;
            if (this.daoCollection.containsKey(deviceTypeVO.getId()) && deviceTypeVO.isDirty()) {
                Object v = this.daoCollection.get(deviceTypeVO.getId());
                System.out.println(v.getClass().getName());
                Integer n = (Integer)this.daoCollection.get(deviceTypeVO.getId());
                DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)((Devices)this.daoObject).getDevices().get(n);
                this.copyTo(deviceImpl, deviceTypeVO);
            }
        } else {
            throw new UpdateException("Invalid Object", null);
        }
    }

    protected void updateObject(IPersistable iPersistable) throws Exception {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)((Devices)this.daoObject).getDevices().get(n);
            this.copyTo(deviceImpl, (DeviceTypeVO)iPersistable);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        DeviceTypeVO deviceTypeVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)((Devices)this.daoObject).getDevices().get(n);
            DeviceTypeVO deviceTypeVO2 = new DeviceTypeVO();
            this.copyFrom(deviceImpl, deviceTypeVO2);
            deviceTypeVO = deviceTypeVO2;
        }
        return deviceTypeVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Devices)this.daoObject).getDevices().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((Devices)this.daoObject).getDevices().size();
            if (!(iPersistable instanceof DeviceTypeVO) || n >= n2) {
                throw new Exception("Invalid parameters being passed");
            }
            DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)this.factory.createDevicesTypeDevice();
            this.copyTo(deviceImpl, (DeviceTypeVO)iPersistable);
            ((Devices)this.daoObject).getDevices().set(n2, deviceImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (!(iPersistable instanceof DeviceTypeVO)) {
                throw new Exception("Invalid Value Object being passed");
            }
            DevicesTypeImpl.DeviceImpl deviceImpl = (DevicesTypeImpl.DeviceImpl)this.factory.createDevicesTypeDevice();
            this.copyTo(deviceImpl, (DeviceTypeVO)iPersistable);
            int n = ((DevicesTypeImpl)this.daoObject).getDevices().size();
            ((DevicesTypeImpl)this.daoObject).getDevices().set(n, deviceImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

